import { Injectable, NotFoundException } from '@nestjs/common';
import { CreateContactusDto } from '../dto/create-contactus.dto';
import { InjectRepository } from '@nestjs/typeorm';
import { Contactus } from '../entity/contactus.entity';
import { Repository } from 'typeorm';

@Injectable()
export class ContactusService {
  constructor(
    @InjectRepository(Contactus)
    private contactusRepository: Repository<Contactus>,
  ) {}

  async addContactUs(contactusData: CreateContactusDto): Promise<Contactus> {
    return await this.contactusRepository.save(contactusData);
  }

  async getAllContactus(): Promise<Contactus[]> {
    return await this.contactusRepository.find();
  }

  async getContactusById(id: number): Promise<Contactus> {
    const fetched_results = await this.contactusRepository.findOneBy({
      idContactus: id,
    });

    if (!fetched_results) {
      throw new NotFoundException(`Contactus with ID ${id} not found! `);
    }

    return fetched_results;
  }

  async updateContactById(id: number, contactusData: CreateContactusDto) {
    const contactUs = await this.contactusRepository.findOneBy({
      idContactus: id,
    });

    if (!contactUs) {
      throw new NotFoundException(`Contactus with ID ${id} not found!`);
    }

    contactUs.Name = contactusData.Name;
    contactUs.Address = contactusData.Address;
    contactUs.Birthday = contactusData.Birthday;
    contactUs.Phone = contactusData.Phone;
    contactUs.Email = contactusData.Email;

    return await this.contactusRepository.save(contactUs);
  }
}
