import {
  BaseEntity,
  BeforeInsert,
  BeforeUpdate,
  Column,
  CreateDateColumn,
  Entity,
  PrimaryGeneratedColumn,
} from 'typeorm';
import * as bycrypt from 'bcrypt';
import { ApiProperty } from '@nestjs/swagger';
@Entity('user')
export class User extends BaseEntity {
  @ApiProperty()
  @PrimaryGeneratedColumn({
    comment: 'the unique identifier',
  })
  idUser: number;
  @ApiProperty()
  @Column({
    type: 'varchar',
    length: 255,
    nullable: false,
  })
  Name: string;
  @ApiProperty()
  @Column({
    type: 'varchar',
    length: 255,
    nullable: false,
    unique: true,
  })
  Email: string;
  @ApiProperty()
  @Column({
    type: 'varchar',
    length: 255,
    nullable: false,
  })
  Password: string;
  @ApiProperty()
  @CreateDateColumn()
  CreatedAt: Date;

  @BeforeInsert()
  async hasPass() {
    const salt = await bycrypt.genSalt();
    this.Password = await bycrypt.hash(this.Password, salt);
  }

  @BeforeUpdate()
  async hasPasswhenUpdating() {
    const salt = await bycrypt.genSalt();
    this.Password = await bycrypt.hash(this.Password, salt);
  }
}
