import { ApiProperty } from '@nestjs/swagger';
import { IsEmail, IsNotEmpty, Matches, Length } from 'class-validator';
import { REGEX, MESSAGES } from 'src/utils/common.utils';

export class UserRegistrationRequestDto {
  @ApiProperty({
    description: 'The name of the user!',
    example: 'isuru chandika',
  })
  @IsNotEmpty({ message: 'Name is required!' })
  @Length(3.255)
  Name: string;

  @ApiProperty({
    description: 'The user email',
    example: 'isururathnayaka321@gmail.com',
  })
  @IsNotEmpty({ message: 'Email is required!' })
  @IsEmail()
  @Length(3.255)
  Email: string;

  @ApiProperty({
    description: 'Password',
    example: 'Isuru@123',
  })
  @IsNotEmpty({ message: 'Password is required!' })
  @Matches(REGEX.PASSWORD_RULE, {
    message:
      'Password should have 1 uppercase lowercase letter and number and special character',
  })
  Password: string;

  @ApiProperty({
    description: 'Pasword Retype',
    example: 'Isuru@123',
  })
  @IsNotEmpty({ message: 'Confirm Password is required!' })
  @Matches(REGEX.PASSWORD_RULE, {
    message: MESSAGES.PASSWORD_RULE_MESSAGE,
  })
  ConfirmPass: string;
}
