import { IsDateString, IsEmail, IsNotEmpty, Length } from 'class-validator';
import { ApiProperty } from '@nestjs/swagger';

export class CreateContactusDto {
  @ApiProperty({
    description: 'The name of the user!',
    example: 'isuru chandika',
  })
  @IsNotEmpty({ message: 'Name is required!' })
  @Length(1, 255)
  Name: string;

  @ApiProperty({
    description: 'The address of the user!',
    example: 'No 10/2 hgaj hdw bg ',
  })
  @IsNotEmpty({ message: 'Address is required!' })
  @Length(2, 255)
  Address: string;

  @ApiProperty({
    description: 'The birthday of the user!',
    example: '2005/03/23',
  })
  @IsNotEmpty({ message: 'Birthday is required!' })
  @Length(2, 255)
  Birthday: string;

  @ApiProperty({
    description: 'The Phone number of the user!',
    example: '09764734892346',
  })
  @IsNotEmpty({ message: 'Phone is required!' })
  @Length(2, 255)
  Phone: string;

  @ApiProperty({
    description: 'The Email of the user!',
    example: 'isuruchandika321@gmail.com',
  })
  @IsNotEmpty({ message: 'Email is required!' })
  @IsEmail({ allow_display_name: true }, { message: '' })
  @Length(2, 255)
  Email: string;
}
