/*
https://docs.nestjs.com/providers#services
*/

import {
  BadRequestException,
  Injectable,
  UnauthorizedException,
} from '@nestjs/common';
import { UserService } from 'src/services/user.service';
import * as bcrypt from 'bcrypt';
import { JwtService } from '@nestjs/jwt';
@Injectable()
export class AuthService {
  constructor(
    private userDbService: UserService,
    private jwtService: JwtService,
  ) {}

  async validateUserCredintials(Email: string, Password: string) {
    console.log('Email is : ', Email);
    console.log('Password is : ', Password);
    const user = await this.userDbService.getUserByEmail(Email);
    if (!user) {
      throw new BadRequestException();
    }
    if (!(await bcrypt.compare(Password, user.Password))) {
      throw new UnauthorizedException();
    }

    return user;
  }

  async genarateToken(user: any): Promise<any> {
    const access_token = this.jwtService.sign({
      Name: user.Name,
      sub: user.idUser,
    });

    return { access_token: access_token };
  }
}
