"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateContactusDto = void 0;
const class_validator_1 = require("class-validator");
const swagger_1 = require("@nestjs/swagger");
class CreateContactusDto {
}
exports.CreateContactusDto = CreateContactusDto;
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'The name of the user!',
        example: 'isuru chandika',
    }),
    (0, class_validator_1.IsNotEmpty)({ message: 'Name is required!' }),
    (0, class_validator_1.Length)(1, 255),
    __metadata("design:type", String)
], CreateContactusDto.prototype, "Name", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'The address of the user!',
        example: 'No 10/2 hgaj hdw bg ',
    }),
    (0, class_validator_1.IsNotEmpty)({ message: 'Address is required!' }),
    (0, class_validator_1.Length)(2, 255),
    __metadata("design:type", String)
], CreateContactusDto.prototype, "Address", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'The birthday of the user!',
        example: '2005/03/23',
    }),
    (0, class_validator_1.IsNotEmpty)({ message: 'Birthday is required!' }),
    (0, class_validator_1.Length)(2, 255),
    __metadata("design:type", String)
], CreateContactusDto.prototype, "Birthday", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'The Phone number of the user!',
        example: '09764734892346',
    }),
    (0, class_validator_1.IsNotEmpty)({ message: 'Phone is required!' }),
    (0, class_validator_1.Length)(2, 255),
    __metadata("design:type", String)
], CreateContactusDto.prototype, "Phone", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'The Email of the user!',
        example: 'isuruchandika321@gmail.com',
    }),
    (0, class_validator_1.IsNotEmpty)({ message: 'Email is required!' }),
    (0, class_validator_1.IsEmail)({ allow_display_name: true }, { message: '' }),
    (0, class_validator_1.Length)(2, 255),
    __metadata("design:type", String)
], CreateContactusDto.prototype, "Email", void 0);
//# sourceMappingURL=create-contactus.dto.js.map