"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContactusController = void 0;
const common_1 = require("@nestjs/common");
const create_contactus_dto_1 = require("../dto/create-contactus.dto");
const contactus_service_1 = require("../services/contactus.service");
const jwt_auth_guard_1 = require("../auth/guards/jwt-auth-guard");
const nodemailer = require('nodemailer');
const swagger_1 = require("@nestjs/swagger");
const common_utils_1 = require("../utils/common.utils");
let ContactusController = class ContactusController {
    constructor(contactusDbService) {
        this.contactusDbService = contactusDbService;
    }
    async getAllContactus() {
        return await this.contactusDbService.getAllContactus();
    }
    async addContactUs(contactusData) {
        const savedContact = await this.contactusDbService.addContactUs(contactusData);
        const transporter = nodemailer.createTransport({
            host: 'optimizesolutions.lk',
            port: 465,
            secure: true,
            auth: {
                user: 'mailservice@optimizesolutions.lk',
                pass: '963580398Vj*',
            },
        });
        const mailOptions = {
            from: '"Optimize Solutions" <mailservice@optimizesolutions.lk>',
            to: 'isuruchandika321@gmail.com',
            subject: 'New Contact Message Received',
            text: `A new contact message has been received:
        Name: ${contactusData.Name}
        Email: ${contactusData.Email}
        Contact Number: ${contactusData.Phone}
        Message: ${contactusData.Birthday}
      `,
            html: `
        <div style="font-family: Arial, sans-serif; color: #333;">
          <div style="padding: 20px; background-color: #f7f7f7; border: 1px solid #ddd; border-radius: 10px;">
            <h2 style="color: #444;">New Message</h2>
            <p style="font-size: 16px;">Dear Team,</p>
            <p style="font-size: 16px;">A new message has been received:</p>
            <ul style="font-size: 16px; list-style: none; padding: 0;">
              <li><strong>Name:</strong> ${contactusData.Name}</li>
              <li><strong>Email:</strong> ${contactusData.Email}</li>
              <li><strong>Contact Number:</strong> ${contactusData.Phone}</li>
              <li><strong>Message:</strong> ${contactusData.Birthday}</li>
            </ul>
            <p style="font-size: 16px; margin-top: 30px;">Thank you,</p>
            <p style="font-size: 16px; font-weight: bold;">Team Optimize Solutions</p>
          </div>
          <div style="text-align: center; padding: 20px 0; font-size: 12px; color: #888;">
            <p>&copy; 2024 Optimize Solutions. All rights reserved.</p>
          </div>
        </div>
      `,
        };
        await transporter.sendMail(mailOptions);
        return savedContact;
    }
    async getContactusById(id) {
        return await this.contactusDbService.getContactusById(id);
    }
    async updateContactById(id, contactusData) {
        return await this.contactusDbService.updateContactById(id, contactusData);
    }
};
exports.ContactusController = ContactusController;
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Get)('/'),
    (0, common_utils_1.ApiDefaultResponses)('Get All completed!'),
    (0, swagger_1.ApiBearerAuth)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], ContactusController.prototype, "getAllContactus", null);
__decorate([
    (0, common_1.Post)('/'),
    (0, common_utils_1.ApiDefaultResponses)('Adding completed!'),
    (0, common_1.UsePipes)(common_1.ValidationPipe),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_contactus_dto_1.CreateContactusDto]),
    __metadata("design:returntype", Promise)
], ContactusController.prototype, "addContactUs", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Get)('/:id'),
    (0, common_utils_1.ApiDefaultResponses)('Get by id completed!'),
    (0, common_1.HttpCode)(200),
    (0, swagger_1.ApiBearerAuth)(),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", Promise)
], ContactusController.prototype, "getContactusById", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Put)('/:id'),
    (0, common_utils_1.ApiDefaultResponses)('updating completed!'),
    (0, common_1.UsePipes)(common_1.ValidationPipe),
    (0, swagger_1.ApiBearerAuth)(),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, create_contactus_dto_1.CreateContactusDto]),
    __metadata("design:returntype", Promise)
], ContactusController.prototype, "updateContactById", null);
exports.ContactusController = ContactusController = __decorate([
    (0, common_1.Controller)('api/contactus'),
    __metadata("design:paramtypes", [contactus_service_1.ContactusService])
], ContactusController);
//# sourceMappingURL=contactus.controller.js.map